local StreamingChunk = CurrentMod
Hooks:PostHook(BLTOptionsMenu, "Init", "StreamingChunkInit", function(self)
	local function set_streaming_chunk(value)
		--saving locally because game decides to reset that option :/
		managers.user:set_setting("max_streaming_chunk", value)
		managers.savefile:save_setting(true)
		StreamingChunk.Options:SetValue("Size", value)
		StreamingChunk.Options:Save()
	end
	local size = math.round_with_precision(StreamingChunk.Options:GetValue("Size"))
	self:Slider({
		name = "StreamingChunk",
		text = "Streaming Chunk Size",
		min = 64,
		max = 16384,
		value_format = "%i",
		value = size,
		localize = false,
		callback = set_streaming_chunk
	})
	set_streaming_chunk(size)
end)